<?php

namespace Module\Account\database\seeds;

use Illuminate\Database\Seeder;
use Module\Account\Models\Account;

class AccountTableSeeder extends Seeder
{

    public function run()
    {
        if (Account::count() < 1) {
            Account::query()->insert($this->data());
        }
    }

    private function data(): array
    {
        return $accounts = array(
            array('id' => '1', 'name' => 'Purchase Return', 'account_group_id' => '8', 'account_control_id' => '24', 'account_subsidiary_id' => '36', 'company_id' => '1', 'balance_type' => 'Credit', 'opening_balance' => '0.00', 'remarks' => NULL, 'status' => '1', 'is_deletable' => '0', 'created_by' => '1', 'updated_by' => '1', 'created_at' => '2021-10-26 14:53:56', 'updated_at' => '2021-10-26 14:53:56'),
            array('id' => '2', 'name' => 'Sales Return', 'account_group_id' => '7', 'account_control_id' => '23', 'account_subsidiary_id' => '35', 'company_id' => '1', 'balance_type' => 'Debit', 'opening_balance' => '0.00', 'remarks' => NULL, 'status' => '1', 'is_deletable' => '0', 'created_by' => '1', 'updated_by' => '1', 'created_at' => '2021-10-26 14:53:56', 'updated_at' => '2021-10-26 14:53:56'),
            array('id' => '4', 'name' => 'Purchase', 'account_group_id' => '6', 'account_control_id' => '24', 'account_subsidiary_id' => '36', 'company_id' => '1', 'balance_type' => 'Debit', 'opening_balance' => '0.00', 'remarks' => NULL, 'status' => '1', 'is_deletable' => '0', 'created_by' => '1', 'updated_by' => '1', 'created_at' => '2021-10-26 14:53:57', 'updated_at' => '2021-10-26 15:04:03'),
            array('id' => '10', 'name' => 'Bank Interest', 'account_group_id' => '5', 'account_control_id' => '19', 'account_subsidiary_id' => '31', 'company_id' => '1', 'balance_type' => 'Debit', 'opening_balance' => '0.00', 'remarks' => NULL, 'status' => '1', 'is_deletable' => '0', 'created_by' => '1', 'updated_by' => '1', 'created_at' => '2021-10-26 14:53:57', 'updated_at' => '2021-10-26 14:53:57'),
            array('id' => '12', 'name' => 'Remuneration (owner)', 'account_group_id' => '5', 'account_control_id' => '17', 'account_subsidiary_id' => '29', 'company_id' => '1', 'balance_type' => 'Debit', 'opening_balance' => '0.00', 'remarks' => NULL, 'status' => '1', 'is_deletable' => '0', 'created_by' => '1', 'updated_by' => '1', 'created_at' => '2021-10-26 14:53:57', 'updated_at' => '2021-10-26 14:53:57'),
            array('id' => '14', 'name' => 'Staff Salary', 'account_group_id' => '5', 'account_control_id' => '16', 'account_subsidiary_id' => '28', 'company_id' => '1', 'balance_type' => 'Debit', 'opening_balance' => '0.00', 'remarks' => NULL, 'status' => '1', 'is_deletable' => '0', 'created_by' => '1', 'updated_by' => '1', 'created_at' => '2021-10-26 14:53:57', 'updated_at' => '2021-10-26 14:53:57'),
            array('id' => '15', 'name' => 'Conveyance Expense (All)', 'account_group_id' => '5', 'account_control_id' => '15', 'account_subsidiary_id' => '27', 'company_id' => '1', 'balance_type' => 'Debit', 'opening_balance' => '0.00', 'remarks' => NULL, 'status' => '1', 'is_deletable' => '0', 'created_by' => '1', 'updated_by' => '1', 'created_at' => '2021-10-26 14:53:58', 'updated_at' => '2021-10-26 14:53:58'),
            array('id' => '17', 'name' => 'House Rent (Main Office)', 'account_group_id' => '5', 'account_control_id' => '14', 'account_subsidiary_id' => '26', 'company_id' => '1', 'balance_type' => 'Debit', 'opening_balance' => '0.00', 'remarks' => NULL, 'status' => '1', 'is_deletable' => '0', 'created_by' => '1', 'updated_by' => '1', 'created_at' => '2021-10-26 14:53:58', 'updated_at' => '2021-10-26 14:53:58'),
            array('id' => '18', 'name' => 'Electricity Bill', 'account_group_id' => '5', 'account_control_id' => '13', 'account_subsidiary_id' => '25', 'company_id' => '1', 'balance_type' => 'Debit', 'opening_balance' => '0.00', 'remarks' => NULL, 'status' => '1', 'is_deletable' => '0', 'created_by' => '1', 'updated_by' => '1', 'created_at' => '2021-10-26 14:53:58', 'updated_at' => '2021-10-26 14:53:58'),
            array('id' => '21', 'name' => 'Adjsutment Expense', 'account_group_id' => '5', 'account_control_id' => '12', 'account_subsidiary_id' => '24', 'company_id' => '1', 'balance_type' => 'Debit', 'opening_balance' => '0.00', 'remarks' => NULL, 'status' => '1', 'is_deletable' => '0', 'created_by' => '1', 'updated_by' => '1', 'created_at' => '2021-10-26 14:53:58', 'updated_at' => '2021-10-26 14:53:58'),
            array('id' => '22', 'name' => 'Entertainment Expense', 'account_group_id' => '5', 'account_control_id' => '11', 'account_subsidiary_id' => '23', 'company_id' => '1', 'balance_type' => 'Debit', 'opening_balance' => '0.00', 'remarks' => NULL, 'status' => '1', 'is_deletable' => '0', 'created_by' => '1', 'updated_by' => '1', 'created_at' => '2021-10-26 14:53:58', 'updated_at' => '2021-10-26 14:53:58'),
            array('id' => '23', 'name' => 'Service Revenue', 'account_group_id' => '4', 'account_control_id' => '10', 'account_subsidiary_id' => '22', 'company_id' => '1', 'balance_type' => 'Credit', 'opening_balance' => '0.00', 'remarks' => NULL, 'status' => '1', 'is_deletable' => '0', 'created_by' => '1', 'updated_by' => '1', 'created_at' => '2021-10-26 14:53:58', 'updated_at' => '2021-10-26 14:53:58'),
            array('id' => '25', 'name' => 'Adjustment Revenue', 'account_group_id' => '4', 'account_control_id' => '8', 'account_subsidiary_id' => '20', 'company_id' => '1', 'balance_type' => 'Credit', 'opening_balance' => '0.00', 'remarks' => NULL, 'status' => '1', 'is_deletable' => '0', 'created_by' => '1', 'updated_by' => '1', 'created_at' => '2021-10-26 14:53:58', 'updated_at' => '2021-10-26 14:53:58'),
            array('id' => '26', 'name' => 'Sales', 'account_group_id' => '4', 'account_control_id' => '7', 'account_subsidiary_id' => '19', 'company_id' => '1', 'balance_type' => 'Credit', 'opening_balance' => '0.00', 'remarks' => NULL, 'status' => '1', 'is_deletable' => '0', 'created_by' => '1', 'updated_by' => '1', 'created_at' => '2021-10-26 14:53:58', 'updated_at' => '2021-10-26 14:53:58'),
            array('id' => '27', 'name' => 'Current Income', 'account_group_id' => '3', 'account_control_id' => '6', 'account_subsidiary_id' => '18', 'company_id' => '1', 'balance_type' => 'Credit', 'opening_balance' => '0.00', 'remarks' => NULL, 'status' => '1', 'is_deletable' => '0', 'created_by' => '1', 'updated_by' => '1', 'created_at' => '2021-10-26 14:53:58', 'updated_at' => '2021-10-26 14:53:58'),
            array('id' => '30', 'name' => 'Capital', 'account_group_id' => '3', 'account_control_id' => '5', 'account_subsidiary_id' => '17', 'company_id' => '1', 'balance_type' => 'Credit', 'opening_balance' => '0.00', 'remarks' => NULL, 'status' => '1', 'is_deletable' => '0', 'created_by' => '1', 'updated_by' => '1', 'created_at' => '2021-10-26 14:53:58', 'updated_at' => '2021-10-26 14:53:58'),
            array('id' => '32', 'name' => 'Loan', 'account_group_id' => '2', 'account_control_id' => '3', 'account_subsidiary_id' => '3', 'company_id' => '1', 'balance_type' => 'Credit', 'opening_balance' => '0.00', 'remarks' => NULL, 'status' => '1', 'is_deletable' => '0', 'created_by' => '1', 'updated_by' => '1', 'created_at' => '2021-10-26 14:53:58', 'updated_at' => '2021-11-04 17:05:04'),
            array('id' => '35', 'name' => 'Accounts Payable Suppliers', 'account_group_id' => '2', 'account_control_id' => '3', 'account_subsidiary_id' => '4', 'company_id' => '1', 'balance_type' => 'Credit', 'opening_balance' => '0.00', 'remarks' => NULL, 'status' => '1', 'is_deletable' => '0', 'created_by' => '1', 'updated_by' => '1', 'created_at' => '2021-10-26 14:53:59', 'updated_at' => '2021-10-26 14:53:59'),
            array('id' => '40', 'name' => 'Glass Decoration', 'account_group_id' => '1', 'account_control_id' => '2', 'account_subsidiary_id' => '6', 'company_id' => '1', 'balance_type' => 'Debit', 'opening_balance' => '0.00', 'remarks' => NULL, 'status' => '1', 'is_deletable' => '0', 'created_by' => '1', 'updated_by' => '1', 'created_at' => '2021-10-26 14:53:59', 'updated_at' => '2021-10-26 14:53:59'),
            array('id' => '42', 'name' => 'Chairs', 'account_group_id' => '1', 'account_control_id' => '2', 'account_subsidiary_id' => '7', 'company_id' => '1', 'balance_type' => 'Debit', 'opening_balance' => '0.00', 'remarks' => NULL, 'status' => '1', 'is_deletable' => '0', 'created_by' => '1', 'updated_by' => '1', 'created_at' => '2021-10-26 14:53:59', 'updated_at' => '2021-10-26 14:53:59'),
            array('id' => '44', 'name' => 'CEO Tables', 'account_group_id' => '1', 'account_control_id' => '2', 'account_subsidiary_id' => '7', 'company_id' => '1', 'balance_type' => 'Debit', 'opening_balance' => '0.00', 'remarks' => NULL, 'status' => '1', 'is_deletable' => '0', 'created_by' => '1', 'updated_by' => '1', 'created_at' => '2021-10-26 14:53:59', 'updated_at' => '2021-10-26 14:53:59'),
            array('id' => '45', 'name' => 'Tables', 'account_group_id' => '1', 'account_control_id' => '2', 'account_subsidiary_id' => '7', 'company_id' => '1', 'balance_type' => 'Debit', 'opening_balance' => '0.00', 'remarks' => NULL, 'status' => '1', 'is_deletable' => '0', 'created_by' => '1', 'updated_by' => '1', 'created_at' => '2021-10-26 14:53:59', 'updated_at' => '2021-10-26 14:53:59'),
            array('id' => '47', 'name' => 'A/C Receivables Customers', 'account_group_id' => '1', 'account_control_id' => '1', 'account_subsidiary_id' => '8', 'company_id' => '1', 'balance_type' => 'Debit', 'opening_balance' => '0.00', 'remarks' => NULL, 'status' => '1', 'is_deletable' => '0', 'created_by' => '1', 'updated_by' => '1', 'created_at' => '2021-10-26 14:53:59', 'updated_at' => '2021-10-26 14:53:59'),
            array('id' => '48', 'name' => 'Bad Stock', 'account_group_id' => '1', 'account_control_id' => '1', 'account_subsidiary_id' => '9', 'company_id' => '1', 'balance_type' => 'Debit', 'opening_balance' => '0.00', 'remarks' => NULL, 'status' => '1', 'is_deletable' => '0', 'created_by' => '1', 'updated_by' => '1', 'created_at' => '2021-10-26 14:53:59', 'updated_at' => '2021-10-26 14:53:59'),
            array('id' => '50', 'name' => 'Current Stock', 'account_group_id' => '1', 'account_control_id' => '1', 'account_subsidiary_id' => '9', 'company_id' => '1', 'balance_type' => 'Debit', 'opening_balance' => '0.00', 'remarks' => NULL, 'status' => '1', 'is_deletable' => '0', 'created_by' => '1', 'updated_by' => '1', 'created_at' => '2021-10-26 14:53:59', 'updated_at' => '2021-10-26 14:53:59'),
            array('id' => '52', 'name' => 'Bank Name', 'account_group_id' => '1', 'account_control_id' => '1', 'account_subsidiary_id' => '10', 'company_id' => '1', 'balance_type' => 'Debit', 'opening_balance' => '0.00', 'remarks' => NULL, 'status' => '1', 'is_deletable' => '0', 'created_by' => '1', 'updated_by' => '1', 'created_at' => '2021-10-26 14:53:59', 'updated_at' => '2021-11-04 16:59:48'),
            array('id' => '54', 'name' => 'Petty Cash', 'account_group_id' => '1', 'account_control_id' => '1', 'account_subsidiary_id' => '11', 'company_id' => '1', 'balance_type' => 'Debit', 'opening_balance' => '0.00', 'remarks' => NULL, 'status' => '1', 'is_deletable' => '0', 'created_by' => '1', 'updated_by' => '1', 'created_at' => '2021-10-26 14:53:59', 'updated_at' => '2021-10-26 14:53:59'),
            array('id' => '55', 'name' => 'Cash', 'account_group_id' => '1', 'account_control_id' => '1', 'account_subsidiary_id' => '11', 'company_id' => '1', 'balance_type' => 'Credit', 'opening_balance' => '0.00', 'remarks' => NULL, 'status' => '1', 'is_deletable' => '0', 'created_by' => '1', 'updated_by' => '1', 'created_at' => '2021-10-26 14:53:59', 'updated_at' => '2021-10-26 14:53:59'),
            array('id' => '56', 'name' => 'Cheque In Hand', 'account_group_id' => '1', 'account_control_id' => '1', 'account_subsidiary_id' => '39', 'company_id' => '1', 'balance_type' => 'Debit', 'opening_balance' => '0.00', 'remarks' => NULL, 'status' => '1', 'is_deletable' => '0', 'created_by' => '1', 'updated_by' => '1', 'created_at' => '2021-10-26 14:53:59', 'updated_at' => '2021-11-04 17:02:40'),
            array('id' => '58', 'name' => 'Office Expenses', 'account_group_id' => '5', 'account_control_id' => '18', 'account_subsidiary_id' => '30', 'company_id' => '1', 'balance_type' => 'Debit', 'opening_balance' => '0.00', 'remarks' => NULL, 'status' => '1', 'is_deletable' => '0', 'created_by' => '1', 'updated_by' => '1', 'created_at' => '2021-10-26 14:54:00', 'updated_at' => '2021-10-26 14:54:00'),
            array('id' => '61', 'name' => 'Credit Card', 'account_group_id' => '1', 'account_control_id' => '1', 'account_subsidiary_id' => '39', 'company_id' => '1', 'balance_type' => 'Debit', 'opening_balance' => '0.00', 'remarks' => NULL, 'status' => '1', 'is_deletable' => '0', 'created_by' => '1', 'updated_by' => '1', 'created_at' => '2021-10-26 14:54:00', 'updated_at' => '2021-11-04 17:02:48'),
            array('id' => '68', 'name' => 'SHOP RENT', 'account_group_id' => '5', 'account_control_id' => '14', 'account_subsidiary_id' => '26', 'company_id' => '1', 'balance_type' => 'Debit', 'opening_balance' => '0.00', 'remarks' => NULL, 'status' => '1', 'is_deletable' => '0', 'created_by' => '1', 'updated_by' => '1', 'created_at' => '2021-10-26 14:54:00', 'updated_at' => '2021-10-26 14:54:00'),
            array('id' => '84', 'name' => 'Dept Account1', 'account_group_id' => '9', 'account_control_id' => '27', 'account_subsidiary_id' => '37', 'company_id' => '1', 'balance_type' => 'Debit', 'opening_balance' => '0.00', 'remarks' => NULL, 'status' => '1', 'is_deletable' => '1', 'created_by' => '1', 'updated_by' => '1', 'created_at' => '2021-11-03 10:25:25', 'updated_at' => '2021-11-03 10:25:25'),
            array('id' => '85', 'name' => 'Acm Dpt Account 1', 'account_group_id' => '10', 'account_control_id' => '28', 'account_subsidiary_id' => '38', 'company_id' => '1', 'balance_type' => 'Credit', 'opening_balance' => '0.00', 'remarks' => NULL, 'status' => '1', 'is_deletable' => '1', 'created_by' => '1', 'updated_by' => '1', 'created_at' => '2021-11-03 10:25:53', 'updated_at' => '2021-11-03 10:25:53')
        );
    }
}
